% created by Nils Hase 2016 (nilshase@math.uni-bremen.de)

% function to integrate the solution in a predefined region (filter)
% This is an attempt to look at the reconstruction ability and find a 
% better measure that allows for slightly misplaced emissions

function f_smoothed = local_int_f(f,filter,plotter)

% Load indexes of land grids
load('synthetic_methane_data','land_grids')

% Dimensions for US setup
dim_x = 94;
dim_y = 31;

% Filter must be matrix (squared makes sense) with uneven size
offset_y = (size(filter,1)-1)/2;
offset_x = (size(filter,2)-1)/2;

ff = zeros(dim_y,dim_x);
ff(land_grids) = f;
ff_conv = conv2(ff,filter);
f_conv = ff_conv(1+offset_y:end-offset_y,1+offset_x:end-offset_x);
f_smoothed = f_conv(land_grids);

if plotter == 1
    map_result(f_smoothed,'locally integrated fluxes');
end

end
